﻿using System;
using System.Collections.Generic;

public enum StockRating
{
    Buy = 0, Accumulate, Hold, Sell
}

public struct Stock
{
    private string name;
    private decimal price;
    private StockRating rating;

    public string Name
    {
        get
        {
            return Name;
        }
        set
        {
            name = value;
        }
    }

    public StockRating Rating
    {
        get
        {
            return rating;
        }
        set
        {
            rating = value;
        }
    }

    public decimal Price
    {
        get
        {
            return price;
        }
        set
        {
            price = value;
        }
    }
}

public class StockBroker : IBroker
{
    Dictionary<string, Stock> m_stocks = new Dictionary<string, Stock>();
    decimal pricePerTrade;
    string brokerName;

    public StockBroker()
        : this(13.59m, "Anonymous")
    {
    }

    public StockBroker(decimal price)
        : this(price, "Anonymous")
    {
    }

    public StockBroker(decimal price, string brokerName)
    {
        pricePerTrade = price;
        this.brokerName = brokerName;
    }

    public string GetRating(string stock)
    {
        Stock myStock = m_stocks[stock];
        return Enum.GetName(typeof(StockRating),
                       myStock.Rating);
    }

    private StockRating AssignRating(Stock newStock)
    {
        Random myRand = new Random();
        int nextRating = myRand.Next(4);
        return (StockRating)Enum.ToObject(
                            typeof(StockRating),
                            nextRating);
    }

    public decimal PricePerTrade
    {
        get
        {
            return pricePerTrade;
        }
        set
        {
            pricePerTrade = value;
            PriceChange(brokerName, value);
        }
    }

    public decimal this[string StockName]
    {
        get
        {
            Stock myStock = m_stocks[StockName];
            return myStock.Price;
        }
        set
        {
            Stock myStock = new Stock();
            myStock.Name = StockName;
            myStock.Price = value;
            myStock.Rating = AssignRating(myStock);

            m_stocks.Add(StockName, myStock);
        }
    }

    public event ChangeRegistrar PriceChange;
}
